function plot_traction(Settings,File,ROI);
% PLOT_TRACTION creates three figures including the bright field image, the
% displacement map and the traction map.
% Xavier Trepat 2008
%Robert Steward 2011




%%

if (strcmpi(Settings.PlotDisp,'Yes')) == 1

for k=1:File.NFiles.Fluorescence,
    
    if (strcmpi(Settings.DedriftImage,'Yes')) == 1

            tempFile = [File.pathname '/Displacements','/', 'DedriftGelDisp_', num2str(k), '.dat'];

       elseif (strcmpi(Settings.SubRotation,'Yes')) == 1 
        
            tempFile = [File.pathname '/Displacements','/', 'RotSubGelDisp_', num2str(k), '.dat'];
            
        else
            
            tempFile = [File.pathname '/Displacements','/', 'GelDisp_', num2str(k), '.dat'];
     
        end
    
    %plot displacement
    if(exist(tempFile)),
        
        TempData=load(tempFile);
        
        x = reshape(TempData(:,1),sqrt(size(TempData(:,1),1)),sqrt(size(TempData(:,1),1)));
        y = reshape(TempData(:,2),sqrt(size(TempData(:,2),1)),sqrt(size(TempData(:,2),1)));
        DispX = reshape(TempData(:,3),sqrt(size(TempData(:,3),1)),sqrt(size(TempData(:,3),1))) *  Settings.PixelSize;%1e6 removed for both DISP 
        DispY = reshape(TempData(:,4),sqrt(size(TempData(:,4),1)),sqrt(size(TempData(:,4),1))) *  Settings.PixelSize;
        Disp = sqrt(DispX.^2+DispY.^2);
    
                
        figh2=figure; set(figh2,'name','Displacements')
        h=pcolor(x,y,(Disp)); 
        set(gca,'YDir','reverse');
        view(2); colormap jet; shading flat; axis image; axis off; set(gca,'CLim',[0 Settings.disp_max]); colorbar; hold on;
        %h=plot(xb, yb,'k'); set(h,'linewidth',2);
        %hq=xquiver(x,y,DispX,DispY,'w'); set(hq,'linewidth',2);set(hq(1),'linestyle','none');
        
         
        saveas(gcf,[File.pathname, '\Results', '/disp', num2str(k),'.jpg'])
    
         
         
             
    end 
      
        
end

close all

end

if (strcmpi(Settings.PlotTracX,'Yes')) == 1

% plot tractions in X

for k=1:File.NFiles.Fluorescence,        
    
    tempFile = [File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction', '.dat'];
    
    
    
    if(exist(tempFile)),
        TempData=load(tempFile);
        
        x = TempData(:,1);
        y = TempData(:,2);
        TracX = TempData(:,3);
        %TracY = TempData(:,4);
        
  
        
        x = reshape(x,sqrt(size(x,1)),sqrt(size(x,1)));
        y = reshape(y,sqrt(size(y,1)),sqrt(size(y,1)));
        TracX = reshape(TracX,sqrt(size(TracX,1)),sqrt(size(TracX,1)));
        %TracY = reshape(TracY,sqrt(size(TracY,1)),sqrt(size(TracY,1)));
          
         
           %crop plot
        if (strcmpi(Settings.cropFig,'Yes')) == 1
            
            row = size(TracX,1);
            column =   size(TracX,2);
            TracX = TracX(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            x = x(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            y = y(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);   
                
          
          end
       
        
            if (strcmpi(Settings.reshapeMatrix,'Yes')) == 1
            
            %resize matrix to reduce pixelation of output
            TracX = imresize(TracX, size(TracX)*2,'bicubic');
            %TracY = imresize(TracY, size(TracY)*2,'bicubic'); 
            x=imresize(x, size(x)*2,'bicubic');
            y=imresize(y, size(y)*2,'bicubic'); 
            
            end
       
        
       
           
        figh3=figure;  set(figh3,'name','Tractions in x')       
        h=pcolor(x,y,TracX);
        set(gca,'YDir','reverse');        
        view(2);  %colormap hot;
        colormap([0.200000002980232 1 1;0.186666667461395 0.933333337306976 0.997435867786407;0.173333331942558 0.866666674613953 0.99487179517746;0.159999996423721 0.800000011920929 0.992307662963867;0.146666675806046 0.733333349227905 0.989743590354919;0.133333340287209 0.666666686534882 0.987179458141327;0.120000004768372 0.600000023841858 0.984615385532379;0.106666669249535 0.533333361148834 0.982051253318787;0.0933333337306976 0.466666668653488 0.979487180709839;0.0799999982118607 0.400000005960464 0.976923048496246;0.0666666701436043 0.333333343267441 0.974358975887299;0.0533333346247673 0.266666680574417 0.971794843673706;0.0399999991059303 0.200000002980232 0.969230771064758;0.0266666673123837 0.133333340287209 0.966666638851166;0.0133333336561918 0.0666666701436043 0.964102566242218;0 0 0.961538434028625;0 0 0.901442289352417;0 0 0.841346144676208;0 0 0.78125;0 0 0.721153855323792;0 0 0.661057651042938;0 0 0.60096150636673;0 0 0.540865361690521;0 0 0.480769217014313;0 0 0.420673072338104;0 0 0.360576927661896;0 0 0.300480753183365;0 0 0.240384608507156;0 0 0.180288463830948;0 0 0.120192304253578;0 0 0.0600961521267891;0 0 0;0.0529411770403385 0.0100490199401975 0;0.105882354080677 0.0200980398803949 0;0.158823534846306 0.030147060751915 0;0.211764708161354 0.0401960797607899 0;0.264705896377563 0.0502450987696648 0;0.317647069692612 0.06029412150383 0;0.37058824300766 0.0703431367874146 0;0.423529416322708 0.0803921595215797 0;0.476470589637756 0.0904411822557449 0;0.529411792755127 0.10049019753933 0;0.582352936267853 0.110539220273495 0;0.635294139385223 0.12058824300766 0;0.688235282897949 0.130637258291245 0;0.74117648601532 0.140686273574829 0;0.794117629528046 0.150735303759575 0;0.847058832645416 0.160784319043159 0;0.856617629528046 0.213235303759575 0;0.86617648601532 0.265686273574829 0;0.875735282897949 0.318137258291245 0;0.885294139385223 0.37058824300766 0;0.894852936267853 0.423039227724075 0;0.904411792755127 0.475490212440491 0;0.913970589637756 0.527941167354584 0;0.923529386520386 0.580392181873322 0;0.93308824300766 0.632843136787415 0;0.942647039890289 0.685294091701508 0;0.952205896377563 0.737745106220245 0;0.961764693260193 0.790196061134338 0;0.971323549747467 0.842647075653076 0;0.980882346630096 0.895098030567169 0;0.990441203117371 0.947549045085907 0;1 1 0]);
        shading flat; axis image; axis off; set(gca,'CLim',[Settings.tracx_min Settings.tracx_max]); colorbar; hold on;
        hold on
        %quiver(x_crop,y_crop,trac_x_crop,trac_y_crop,3,'color','w')    
        %h=plot(xb, yb,'k'); set(h,'linewidth',2);
        %hq=xquiver(x,y,TracX,TracY,'w'); set(hq,'linewidth',2);set(hq(1),'linestyle','none');
        
        if (strcmpi(Settings.height,'infinite')) == 1
    
             saveas(gcf,[File.pathname, 'Results', '/tracx_unct', num2str(k),'.jpg'])
    
         elseif (strcmpi(Settings.height,'finite')) == 1
        
            saveas(gcf,[File.pathname, 'Results', '/tracx_finite_unct', num2str(k),'.jpg']) 
         else
             
             saveas(gcf,[File.pathname, 'Results', '/tracx_ct', num2str(k),'.jpg']) 
             
         end        
        
    end
 
end   %delete both end statments below

close all

end

if (strcmpi(Settings.PlotTracY,'Yes')) == 1
  
    %plot tractions in Y
    for k=1:File.NFiles.Fluorescence,        
    
    tempFile = [File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction', '.dat'];
    
    %tempFile = [File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction_rot_sub', '.dat'];
    
    
    if(exist(tempFile)),
        TempData=load(tempFile);
        
        x = TempData(:,1);
        y = TempData(:,2);
        %TracX = TempData(:,3);
        TracY = TempData(:,4);
        
       
        
        x = reshape(x,sqrt(size(x,1)),sqrt(size(x,1)));
        y = reshape(y,sqrt(size(y,1)),sqrt(size(y,1)));
        %TracX = reshape(TracX,sqrt(size(TracX,1)),sqrt(size(TracX,1)));
        TracY = reshape(TracY,sqrt(size(TracY,1)),sqrt(size(TracY,1)));
        
         
           %crop plot
        if (strcmpi(Settings.cropFig,'Yes')) == 1
            
            row = size(TracY,1);
            column =   size(TracY,2);
            TracY = TracY(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            x = x(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            y = y(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);   
                
          
          end
        
       
        
            if (strcmpi(Settings.reshapeMatrix,'Yes')) == 1
            
            %resize matrix to reduce pixelation of output
            %TracX = imresize(TracX, size(TracX)*2,'bicubic');
            TracY = imresize(TracY, size(TracY)*2,'bicubic'); 
            x=imresize(x, size(x)*2,'bicubic');
            y=imresize(y, size(y)*2,'bicubic'); 
            
            end
       
        
        %xb= File.Boundary(1).x;
        %yb= File.Boundary(1).y;        
           
        figh3=figure;  set(figh3,'name','Tractions in y')       
        h=pcolor(x,y,TracY);
        set(gca,'YDir','reverse');        
        view(2);  colormap jet;
        %colormap([0.200000002980232 1 1;0.186666667461395 0.933333337306976 0.997435867786407;0.173333331942558 0.866666674613953 0.99487179517746;0.159999996423721 0.800000011920929 0.992307662963867;0.146666675806046 0.733333349227905 0.989743590354919;0.133333340287209 0.666666686534882 0.987179458141327;0.120000004768372 0.600000023841858 0.984615385532379;0.106666669249535 0.533333361148834 0.982051253318787;0.0933333337306976 0.466666668653488 0.979487180709839;0.0799999982118607 0.400000005960464 0.976923048496246;0.0666666701436043 0.333333343267441 0.974358975887299;0.0533333346247673 0.266666680574417 0.971794843673706;0.0399999991059303 0.200000002980232 0.969230771064758;0.0266666673123837 0.133333340287209 0.966666638851166;0.0133333336561918 0.0666666701436043 0.964102566242218;0 0 0.961538434028625;0 0 0.901442289352417;0 0 0.841346144676208;0 0 0.78125;0 0 0.721153855323792;0 0 0.661057651042938;0 0 0.60096150636673;0 0 0.540865361690521;0 0 0.480769217014313;0 0 0.420673072338104;0 0 0.360576927661896;0 0 0.300480753183365;0 0 0.240384608507156;0 0 0.180288463830948;0 0 0.120192304253578;0 0 0.0600961521267891;0 0 0;0.0529411770403385 0.0100490199401975 0;0.105882354080677 0.0200980398803949 0;0.158823534846306 0.030147060751915 0;0.211764708161354 0.0401960797607899 0;0.264705896377563 0.0502450987696648 0;0.317647069692612 0.06029412150383 0;0.37058824300766 0.0703431367874146 0;0.423529416322708 0.0803921595215797 0;0.476470589637756 0.0904411822557449 0;0.529411792755127 0.10049019753933 0;0.582352936267853 0.110539220273495 0;0.635294139385223 0.12058824300766 0;0.688235282897949 0.130637258291245 0;0.74117648601532 0.140686273574829 0;0.794117629528046 0.150735303759575 0;0.847058832645416 0.160784319043159 0;0.856617629528046 0.213235303759575 0;0.86617648601532 0.265686273574829 0;0.875735282897949 0.318137258291245 0;0.885294139385223 0.37058824300766 0;0.894852936267853 0.423039227724075 0;0.904411792755127 0.475490212440491 0;0.913970589637756 0.527941167354584 0;0.923529386520386 0.580392181873322 0;0.93308824300766 0.632843136787415 0;0.942647039890289 0.685294091701508 0;0.952205896377563 0.737745106220245 0;0.961764693260193 0.790196061134338 0;0.971323549747467 0.842647075653076 0;0.980882346630096 0.895098030567169 0;0.990441203117371 0.947549045085907 0;1 1 0]);
        shading flat; axis image; axis off; set(gca,'CLim',[Settings.tracx_min Settings.tracx_max]); colorbar; hold on;
        hold on
        %quiver(x_crop,y_crop,trac_x_crop,trac_y_crop,3,'color','w')    
        %h=plot(xb, yb,'k'); set(h,'linewidth',2);
        %hq=xquiver(x,y,TracX,TracY,'w'); set(hq,'linewidth',2);set(hq(1),'linestyle','none');
        
        if (strcmpi(Settings.height,'infinite')) == 1
    
             saveas(gcf,[File.pathname, 'Results', '/tracy_unct', num2str(k),'.jpg'])
    
         elseif (strcmpi(Settings.height,'finite')) == 1
        
            saveas(gcf,[File.pathname, 'Results', '/tracy_finite_unct', num2str(k),'.jpg']) 
         else
             
             saveas(gcf,[File.pathname, 'Results', '/tracy_ct', num2str(k),'.jpg']) 
             
         end         
        
    end
    %delete both ends below
 
  end

close all

end

    
if (strcmpi(Settings.PlotRmsTrac,'Yes')) == 1
   
    % plot rmstractions
    for k=1:File.NFiles.Fluorescence,
    
    tempFile = [File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction', '.dat'];
    
    %tempFile = [File.pathname 'Tractions','/', 'Time', num2str(k), '/', 'traction_rot_sub', '.dat'];
    
    if(exist(tempFile)),
        TempData=load(tempFile);
        
        x = reshape(TempData(:,1),sqrt(size(TempData(:,1),1)),sqrt(size(TempData(:,1),1)));
        y = reshape(TempData(:,2),sqrt(size(TempData(:,2),1)),sqrt(size(TempData(:,2),1)));
        TracX = real(reshape(TempData(:,3),sqrt(size(TempData(:,3),1)),sqrt(size(TempData(:,3),1))));
        TracY = real(reshape(TempData(:,4),sqrt(size(TempData(:,4),1)),sqrt(size(TempData(:,4),1))));
        Trac = sqrt(TracX.^2+TracY.^2);
        
        
         
           %crop plot
        if (strcmpi(Settings.cropFig,'Yes')) == 1
            
            row = size(Trac,1);
            column =   size(Trac,2);
            Trac = Trac(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            x = x(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);
            y = y(Settings.RowCrop:row-Settings.RowCrop,Settings.ColCrop:column-Settings.ColCrop);   
                
          
          end
        
            if (strcmpi(Settings.reshapeMatrix,'Yes')) == 1 
        
            %resize matrix to reduce pixelation of output
            TracX = imresize(TracX, size(TracX)*2,'bicubic');
            TracY = imresize(TracY, size(TracY)*2,'bicubic');   
            Trac = imresize(Trac, size(Trac)*2,'bicubic');
            x=imresize(x, size(x)*2,'bicubic');
            y=imresize(y, size(y)*2,'bicubic');  
        
            end
        
        
        figh3=figure;  set(figh3,'name','Tractions')       
        h=pcolor(x,y,Trac);
        set(gca,'YDir','reverse');  
        %hold on
        %quiver(x,y,TracX,TracY,15,'color','r')        
        colormap jet; shading flat; axis off; set(gca,'CLim',[0 Settings.trac_max]); colorbar; hold on;
        
        
        if (strcmpi(Settings.height,'infinite')) == 1
    
             saveas(gcf,[File.pathname, 'Results', '/rmsTrac_unct', num2str(k),'.jpg'])
    
         elseif (strcmpi(Settings.height,'finite')) == 1
        
            saveas(gcf,[File.pathname, 'Results', '/rmsTrac_finite_unct', num2str(k),'.jpg']) 
         else
             
             saveas(gcf,[File.pathname, 'Results', '/rmsTrac_ct', num2str(k),'.jpg']) 
             
         end         
    end    
    end
    %}
   close all
   
end
cd('C:\code\Trac_MSM_Code\Data');
end



